library(ggpubr)
library(rstatix)
library(xlsx)
library(car)

###IMPORT & FORMAT DATA###

Data.norm <- read.xlsx("Segment_Lengths_Volumes.xlsx", sheetIndex = 1, header = TRUE, row.names = 1)
Data.raw <- read.xlsx("Segment_Lengths_Volumes.xlsx", sheetIndex = 2, header = TRUE, row.names = 1)

lin.norm <- Data.norm[,1:16]
hull.norm <- Data.norm[,c(1,17:26)]
skin.norm <- Data.norm[,c(1,27:36)]

lin.raw <- Data.raw[,1:16]
hull.raw <- Data.raw[,c(1,17:26)]
skin.raw <- Data.raw[,c(1,27:36)]

###OUTLIERS###
Data.raw.rows <- colnames(Data.raw[,2:36])
#L_Thigh, H_Thigh, S_Neck

for(i in Data.raw.rows){
names <- i
outliers <-  Data.raw %>% 
              group_by(Breed) %>%
              identify_outliers(i)

if(nrow(outliers) > 0){
  for(i in nrow(outliers)) {
  if(outliers[i,'is.extreme'] == 'TRUE'){
    print(names)
    print(outliers)}}}
}


Data.norm.rows <- colnames(Data.norm[,2:36])
#L_Shoulder, L_GA, H_Head, H_Neck, S_Forearm, S_Pes

for(i in Data.norm.rows){
  names <- i
  outliers <-  Data.norm %>% 
    group_by(Breed) %>%
    identify_outliers(i)
  
  if(nrow(outliers) > 0){
    for(i in nrow(outliers)) {
      if(outliers[i,'is.extreme'] == 'TRUE'){
        print(names)
        print(outliers)}}}
}


###NORMALITY OF RESIDUALS###

#Raw

tiff(filename = "Figure S1_Lin_Raw_QQ.tif", width = 222, height = 166, units = "mm", res = 600)

Lin.raw.rows <- colnames(lin.raw[,2:16])
par(mfrow = c(3, 5), mar = c(2, 2, 2, 1))
for(i in Lin.raw.rows){
  names <- i
  res.aov <- aov(data = lin.raw, lin.raw[,i] ~ Breed)
  qqPlot(res.aov$residuals, id = FALSE, xlab = '', ylab = '', main = paste(names))}

dev.off()

tiff(filename = "Figure S1_Hull_Raw_QQ.tif", width = 222, height = 166, units = "mm", res = 600)

Hull.raw.rows <- colnames(hull.raw[,2:11])
par(mfrow = c(2, 5), mar = c(2, 2, 2, 1))
for(i in Hull.raw.rows){
  names <- i
  res.aov <- aov(data = hull.raw, hull.raw[,i] ~ Breed)
  qqPlot(res.aov$residuals, id = FALSE, xlab = '', ylab = '', main = paste(names))}

dev.off()

tiff(filename = "Figure S1_Skin_Raw_QQ.tif", width = 222, height = 166, units = "mm", res = 600)

Skin.raw.rows <- colnames(skin.raw[,2:11])
par(mfrow = c(2, 5), mar = c(2, 2, 2, 1))
for(i in Skin.raw.rows){
  names <- i
  res.aov <- aov(data = skin.raw, skin.raw[,i] ~ Breed)
  qqPlot(res.aov$residuals, id = TRUE, xlab = '', ylab = '', main = paste(names))}

dev.off()

#Normalised

tiff(filename = "Figure S2_Lin_Norm_QQ.tif", width = 222, height = 166, units = "mm", res = 600)

Lin.norm.rows <- colnames(lin.norm[,2:16])
par(mfrow = c(3, 5), mar = c(2, 2, 2, 1))
for(i in Lin.norm.rows){
  names <- i
  res.aov <- aov(data = lin.norm, lin.norm[,i] ~ Breed)
  qqPlot(res.aov$residuals, id = FALSE, xlab = '', ylab = '', main = paste(names))}

dev.off()


tiff(filename = "Figure S2_Hull_Norm_QQ.tif", width = 222, height = 166, units = "mm", res = 600)

Hull.norm.rows <- colnames(hull.norm[,2:11])
par(mfrow = c(2, 5), mar = c(2, 2, 2, 1))
for(i in Hull.norm.rows){
  names <- i
  res.aov <- aov(data = hull.norm, hull.norm[,i] ~ Breed)
  qqPlot(res.aov$residuals, id = FALSE, xlab = '', ylab = '', main = paste(names))}

dev.off()


tiff(filename = "Figure S2_Skin_Norm_QQ.tif", width = 222, height = 166, units = "mm", res = 600)

Skin.norm.rows <- colnames(skin.norm[,2:11])
par(mfrow = c(2, 5), mar = c(2, 2, 2, 1))
for(i in Skin.norm.rows){
  names <- i
  res.aov <- aov(data = skin.norm, skin.norm[,i] ~ Breed)
  qqPlot(res.aov$residuals, id = FALSE, xlab = '', ylab = '', main = paste(names))}

dev.off()

###HOMOSCEDASTICTY###

#Raw

Lin.raw.rows <- colnames(lin.raw[,2:16])
for(i in Lin.raw.rows){
  names <- i
  res.lev <- levene_test(data = lin.raw, lin.raw[,i] ~ Breed)
if(res.lev[,'p'] < 0.05){
  print(names)
  print(res.lev)}
}

Hull.raw.rows <- colnames(hull.raw[,2:11])
for(i in Hull.raw.rows){
  names <- i
  res.lev <- levene_test(data = hull.raw, hull.raw[,i] ~ Breed)
  if(res.lev[,'p'] < 0.05){
    print(names)
    print(res.lev)}
}

#S_Neck, S_Torso, S_Manus, S_Thigh, S_TMT
Skin.raw.rows <- colnames(skin.raw[,2:11])
for(i in Skin.raw.rows){
  names <- i
  res.lev <- levene_test(data = skin.raw, skin.raw[,i] ~ Breed)
  if(res.lev[,'p'] < 0.05){
    print(names)
    print(res.lev)}
}

#Normalised

#L_TotalHind
Lin.norm.rows <- colnames(lin.norm[,2:16])
for(i in Lin.norm.rows){
  names <- i
  res.lev <- levene_test(data = lin.norm, lin.norm[,i] ~ Breed)
  if(res.lev[,'p'] < 0.05){
    print(names)
    print(res.lev)}
}


Hull.norm.rows <- colnames(hull.norm[,2:11])
for(i in Hull.norm.rows){
  names <- i
  res.lev <- levene_test(data = hull.norm, hull.norm[,i] ~ Breed)
  if(res.lev[,'p'] < 0.05){
    print(names)
    print(res.lev)}
}

Skin.norm.rows <- colnames(skin.norm[,2:11])
for(i in Skin.norm.rows){
  names <- i
  res.lev <- levene_test(data = skin.norm, skin.norm[,i] ~ Breed)
  if(res.lev[,'p'] < 0.05){
    print(names)
    print(res.lev)}
}
